clear variables 
close all
clc

%Esercitazione: calcolare il potenziale in un punto P nello spazio (15,1,0) [cm]. La fibra è lunga 80cm ed è stimolata al centro (0,0,0) [cm] con una carica di 10*10^(-9) C.
%1)eseguire prima "HH_sim_fin_propx.m" con L=40cm e stimolo=10e-9 C
        %->otteniamo Vm
%2) integrare secondo il metodo visto a lezione
 
load('pext');

d=1.0;%cm distanza elettrodo fibra
x1=15; %posizione elettrodo misura

P1=[x1 d 0]';


a=0.0238; %cm raggio 
p_i=34.5/1000; %kohm*cm resistività intracellulare
sigmao=100/p_i; 


dx=x(2)-x(1); %passo x
dt=t(2)-t(1); %passo t

%la parte iniziale e la parte finale randono il calcolo (numerico) della
%derivata sbagliato > tolgo un tratto  DT al'inizio e alla fine

DT=round(length(t)/10);



for i=1+DT:length(t)-DT
    t1(i)=t(i);
    d2Vm=diff(diff(Vm(i,:)))/dx^2; %calvolo la derivata seconda spaziale del potenziale di membrana
    %azzero la variabili di integrazione
    accP1=0;
    for j=1:length(x)-2 % ad ogni istante di tempo risolvo l'integrale (numericamente) 
        accP1=accP1  + ( a^2 / (4*sigmao*p_i))  * (d2Vm(j)*dx)/((x(j)-P1(1))^2+d^2)^0.5;
    end
    V_P1(i)=accP1;    
end

figure
subplot(2,1,1)
plot(t1,V_P1)
xlabel('[msec]');
ylabel('[mV]');
legend('Vext');
subplot(2,1,2)
plot(t,Vm(:,x1/dx))
xlabel('[msec]');
ylabel('[mV]');
legend('Vm');






