clear
%Dati del problema
global m J Fx1 Fx2 Fy1 Fy2 delta_eq R a b Co S ro z1eq z2eq
m=(540*sqrt(2)+225)
J=300
Fx1=800
Fx2=500
Fy1=400
Fy2=250
delta_eq=(pi/4)
R=90
a=1
b=12/5*sqrt(2)
Co=0.8
S=2
ro=1.5
z1eq=10
z3eq=z1eq/R

%Funzoni non lineari del sistema

   %f1=z2*z3+1/m*(Fx1*cos(delta_eq)+Fx2-Fy1*sin(delta_eq)-1/2*ro*S*Co*(z1^2))
   %f2=-z1*z3+1/m*(Fy1*cos(delta_eq)+Fy2+Fx1*sin(delta_eq))
   %f3=1/J*(Fy1*a*cos(delta_eq)-Fy2*b+Fx1*a*sin(delta_eq));
   
%Posizione di equilibrio di z2:

z2eq=-(1/m*(Fx1*cos(delta_eq)+Fx2-Fy1*sin(delta_eq)-1/2*ro*S*Co*(z1eq^2)))/z3eq;

%Sistema traslato
   %f1l=(x2+z2eq)*(x3+z3eq)+1/m*(Fx1*cos(u+delta_eq)+Fx2-Fy1*sin(u+delta_eq)-1/2*ro*S*Co*(x1+z1eq)^2))
   %f2l=-(x1+z1eq)*(x3+z3eq)+1/m*(Fy1*cos(u+delta_eq)+Fy2+Fx1*sin(u+delta_eq))
   %f3l=1/J*(Fy1*a*cos(u+delta_eq)-Fy2*b+Fx1*a*sin(u+delta_eq));
%uscita
   %y=(x1+z1eq)/(x3+z3eq)-(z1eq/z3eq)
disp('                                         SISTEMA LINEARE')

x1=0
x2=0
x3=0
u=0
A=[2*1/m*(-1/2*ro*S*Co)*z1eq x3+z3eq x2+z2eq;-x3-z3eq 0 -x1-z1eq;0 0 0]
B=[1/m*(-Fx1*sin(u+delta_eq)-Fy1*cos(u+delta_eq));1/m*(-Fy1*sin(u+delta_eq)+Fx1*cos(u+delta_eq));1/J*(-Fy1*a*sin(u+delta_eq)+Fx1*a*cos(u+delta_eq))]
C=[1/(x3+z3eq) 0 -(x1+z1eq)/(x3+z3eq)^2]

%Funzioni nelsimullink
   %lineare:
      %funz1=A(1,1)*u[1]+A(1,2)*u[2]+A(1,3)*u[3]+B(1)*u[4]
      %funz2=A(2,1)*u[1]+A(2,3)*u[2]+B(2)*u[3]
      %funz3=B(3)*u[1]
      %Y=C(1)*u[1]+C(3)*u[2]
   %non lineare:
      %fnc1=(u[2]+z2eq)*(u[3]+z3eq)+1/m*(Fx1*cos(u[4]+delta_eq)+Fx2-Fy1*sin(u[4]+delta_eq)-1/2*ro*S*Co*(u[1]+z1eq)^2)
      %fnc2=-(u[1]+z1eq)*(u[2]+z3eq)+1/m*(Fy1*cos(u[3]+delta_eq)+Fy2+Fx1*sin(u[3]+delta_eq))
      %fnc3=1/J*(Fy1*a*cos(u[1]+delta_eq)-Fy2*b+Fx1*a*sin(u[1]+delta_eq))
      %Y=(u[1]+z1eq)/(u[2]+z3eq)-(z1eq/z3eq)
   
%funzione di trasferimento
disp('                                         FUNZIONE DI TRASFERIMENTO')

R=ctrb(A,B)
rangoR=rank(R)
O=obsv(A,C)
rangoO=rank(O)
sys=ss(A,B,C,0)
G=tf(sys)
zpk(G)
poli=eig(G)



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Regolatore

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


disp('                                         REGOLATORE')

p=[-0.015+0.15i -0.015-0.15i -3]

q=[-0.15,-0.15,-15];

K=acker(A,B,p)

L=transpose(acker(A',C',q))

regsys=reg(sys,K,L)

[Areg,Breg,Creg,Dreg]=ssdata(regsys)

fsys=feedback(series(regsys,sys),1,+1)
[Af,Bf,Cf,Df]=ssdata(fsys)

zpk(fsys)
figure(1)
clf
step(-fsys,200)
disp('La stima della Ras con metodo empirico che segue  settata con 1(=numras) numero di cicli')
disp('con una iterazione random di 50000(=vfin) elementi, mentre come matrice Q per la candidata di Lyapunov')
disp(' attiva la matrice diagonale random(=Qrand).')
disp('Se non si desidera modificare alcun parametro:')
disp('Premere invio per continuare con la stima della RAS')
pause




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Stima RAS con metodo empirico

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


disp('                                         LYAPUNOV')
disp('Introdurre il valore di r = ')

figure(2)
%clf
figure(3)
%clf
figure(4)
%clf



rdefault=1

numras=1
for k=1:numras                  % questo ciclo va a sovrascrivere un numero di RAS 
                                % pari al valore numras.
                           % ATTENZIONE per non occupare per troppo
                           % tempo il calcolatore si considerino insieme il
                           % numras e il vf.Per k=1 si disattivi il
                           % pause(5) finale.
r=rdefault

r=input('inserisci r ')         % se si disattiva questa linea il valore come r  assunto quello di 
                                % default definito in line 111.Si disattivi
                                % anche  pause finale.
                                

%Q=eye(6)        % attivando questa line bisogna disattivare le 2  successive che invece costruiscono una
                % matrice d.p.
                
Qrand=diag(rand(6,1))    
                               

Q=Qrand'*Qrand         % la Q che compare in Lyapunov deve essere d.p.,
                       % quindi per det(Qrand)>0 si ha che Q=Qrand'*Qrand  d.p. per costruzione.
                      


Pq=lyap(Af,Q)
  M=inv(sqrtm(Pq));
  figure(2)
  % clf
  vin=1;
  vf=50000;

  ras=0;
  
     while ras==0  % ripete fino a quando siamo fuori dalla RAS
      
  
         zplot=zeros(6,vf-vin+1);   % inizializzazione del vettore 6 x vf che memorizzer i vettori z
  
             for i=vin:10:vf
                 x=(rand(6,1)-0.5);
                 y=sqrt(r)*x/norm(x);
                 z=M*y;
                 u=-K*z(4:6);
                 vdot =-z'*Q*z+ 2*z'*Pq*[(z(2)+z2eq)*(z(3)+z3eq)+1/m*(Fx1*cos(u+delta_eq)+Fx2-Fy1*sin(u+delta_eq)-1/2*ro*S*Co*(z(1)+z1eq)^2)-(A(1,1)*z(1)+A(1,2)*z(2)+A(1,3)*z(3)+B(1)*u), 
                                         -(z(1)+z1eq)*(z(3)+z3eq)+1/m*(Fy1*cos(u+delta_eq)+Fy2+Fx1*sin(u+delta_eq))-(A(2,1)*z(1)+A(2,3)*z(3)+B(2)*u),
                                         1/J*(Fy1*a*cos(u+delta_eq)-Fy2*b+Fx1*a*sin(u+delta_eq))-B(3)*u,
                                         0, 
                                         0, 
                                         0]
         i
                  
         if vdot>0 ,disp('out'),ras=0;break;end
            zplot(1:6,i)=z(1:6,1);   % memorizza i vettori z
                                     % se si arriva a i=vf, allora tutti i vettori z
                                     % memorizzati fanno parte della RAS.
            ras=1;                       
             end  % end di for i
   
                          if ras==1
       
                               figure(2)
                               % clf
                                        for i=vin:1:vf
                                            plot(zplot(1,i),zplot(2,i),'om')
                                            hold on
                                            xlabel('z(1)')
                                            ylabel('z(2)')
                                        end
                               figure(3)
                               % clf
                                        for i=vin:1:vf
                                            plot(zplot(2,i),zplot(3,i),'or')
                                            hold on
                                            xlabel('z(2)')
                                            ylabel('z(3)')
                                        end
                                figure(4)
                                % clf       
                                        for i=vin:1:vf
                                            plot3(zplot(1,i),zplot(2,i),zplot(3,i),'og')
                                            hold on
                                            grid on
                                            xlabel('z(1)')
                                            ylabel('z(2)')
                                            zlabel('z(3)')
                                        end
                                
                              else
                                disp('Punto forse fuori dalla RAS')
                           end  % end di if ras==1


                           if ras==0          % se siamo fuori dalla RAS 
                                              % il valore di r viene decrementato fino a quando ras=1 
                              r=r*0.2
    
                              % pause
                           end

     end  % end di while

% pause(5)
    
end  % end di for k
disp('FINE')  